//
//  v002BlurPlugIn.h
//  v002Blur
//
//  Created by vade on 7/10/08.
//  Copyright (c) 2008 __MyCompanyName__. All rights reserved.
//

#import <Quartz/Quartz.h>

@interface v002_DilatePlugIn : QCPlugIn
{
	const GLcharARB    *fragmentShaderSource;								// the GLSL source for our fragment Shader
	const GLcharARB    *vertexShaderSource;									// the GLSL source for our vertex Shader
	GLhandleARB		    glslProgramObject;									// the program object
	
	id<QCPlugInContext> pluginContext;	
}

/*
 Declare here the Obj-C 2.0 properties to be used as input and output ports for the plug-in e.g.
 @property double inputFoo;
 @property(assign) NSString* outputBar;
 You can access their values in the appropriate plug-in methods using self.inputFoo or self.inputBar
 */

@property (assign) id<QCPlugInInputImageSource> inputImage;
@property (assign) double inputAmount;
@property (assign) id<QCPlugInOutputImageProvider> outputImage;


@end

@interface v002_DilatePlugIn (Execution)

#pragma mark -
#pragma mark Shader Handling

- (GLcharARB *) getShaderSourceFromResource:(NSString *)theShaderResourceName extension:(NSString *)theExtension;
- (GLhandleARB) loadShader:(GLenum)theShaderType shaderSource:(const GLcharARB **)theShaderSource;
- (BOOL) newProgramObject:(GLhandleARB)theVertexShader  fragmentShaderHandle:(GLhandleARB)theFragmentShader;
- (BOOL) setProgramObject;
- (BOOL) loadShadersFromResource:(NSString *)theShadersName;
- (void) getFragmentShaderSourceFromResource:(NSString *)theFragmentShaderResourceName;
- (void) getVertexShaderSourceFromResource:(NSString *)theVertexShaderResourceName;

@end
